// XISLBeginEndTag.cpp: CXISLBeginEndTag NX̃Cve[V
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "ib.h"
#include "XISLBeginTag.h"
#include "XISLOutputBrowser.h"
#include "XISLCombOutputTag.h"
#include "XISLCallTag.h"
#include "XISLVarList.h"
#include "XISLActTag.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

//////////////////////////////////////////////////////////////////////
// \z/
//////////////////////////////////////////////////////////////////////

CXISLBeginEndTag::CXISLBeginEndTag(CXISLTag *pParent,int nType)
{
	m_pParentTag = pParent;

	m_nTagType = nType;
	if(nType == ID_TAG_BEGIN)
		m_nBmpID = IDB_BEGIN;
	else if(nType == ID_TAG_END)
		m_nBmpID = IDB_END;
	else
		ASSERT(NULL);

	m_pXISLAct = new CXISLActTag(this,FALSE);
	m_pLocalVar = new CXISLVarList(this);
}


CXISLBeginEndTag::CXISLBeginEndTag(const CXISLBeginEndTag &cpXISL)
{
	m_nTagType = cpXISL.m_nTagType;
	m_strXISL = cpXISL.m_strXISL;
	m_rectBMP = cpXISL.m_rectBMP;
	m_nBmpID = cpXISL.m_nBmpID;
	m_htreeItem = cpXISL.m_htreeItem;
	m_pParentTag = cpXISL.m_pParentTag;

	m_pXISLAct = cpXISL.m_pXISLAct;
	m_pLocalVar = cpXISL.m_pLocalVar;
}


CXISLBeginEndTag::~CXISLBeginEndTag()
{
	delete m_pXISLAct;
	m_pXISLAct = NULL;
	delete m_pLocalVar;
	m_pLocalVar = NULL;
}

CXISLBeginEndTag& CXISLBeginEndTag::operator=(const CXISLBeginEndTag &cpXISL)
{
	if(&cpXISL != this)
	{
		m_nTagType = cpXISL.m_nTagType;
		m_strXISL = cpXISL.m_strXISL;
		m_rectBMP = cpXISL.m_rectBMP;
		m_nBmpID = cpXISL.m_nBmpID;
		m_htreeItem = cpXISL.m_htreeItem;
		m_pParentTag = cpXISL.m_pParentTag;

		m_pXISLAct = cpXISL.m_pXISLAct;
		m_pLocalVar = cpXISL.m_pLocalVar;
	}
	return *this;
}


//LPCTSTR CXISLBeginEndTag::GetXISLString()
//@\@FbeginȉXISLԂ
//@F
//ԂlFLPCTSTRCXISL
LPCTSTR CXISLBeginEndTag::GetXISLString()
{
	m_strXISL = "<";
	m_strXISL += XISL_TAG_NAME[m_nTagType];
	m_strXISL += ">\r\n";

	m_strXISL += m_pXISLAct->GetXISLString();

	m_strXISL += "</";
	m_strXISL += XISL_TAG_NAME[m_nTagType];
	m_strXISL += ">\r\n";
	return m_strXISL;
}

//int CXISLBeginEndTag::GetItemCount()
//@\@FbeginȉXISL̃c[ڐԂ
//@F
//߂lFintCc[ڐ
int CXISLBeginEndTag::GetItemCount()
{
	int nCount;
	nCount = m_pXISLAct->GetItemCount();
	nCount++; //<exchange>̕
	return nCount;
}


//BOOL CXISLBeginEndTag::RegistXISLTree(CTreeCtrl *pTree,HTREEITEM hParent)
//@\@Fc[Rg[XISL^Oo^
//@FCTreeCtrl *pTree  :o^c[Rg[
//		  HTREEITEM hParent :eڂ̃nh
//ԂlFBOOL@FTRUE@sFFALSE
BOOL CXISLBeginEndTag::RegistXISLTree(CTreeCtrl *pTree,HTREEITEM hParent)
{
	TVINSERTSTRUCTA tvs;
	TVITEMA tvi;

	tvs.hInsertAfter = TVI_LAST;
	tvi.mask = TVIF_TEXT | TVIF_PARAM | TVIF_IMAGE | TVIF_SELECTEDIMAGE;
	tvs.hParent = hParent;

	//c[ɓo^
	tvi.pszText = XISL_TAG_NAME[m_nTagType];
	tvi.lParam = (LPARAM)this;
	tvi.iImage = 0;
	tvi.iSelectedImage = 1;
	tvs.item = tvi;
	hParent = pTree->InsertItem(&tvs);
	m_htreeItem = hParent;

	m_pXISLAct->RegistXISLTree(pTree,hParent);

	return TRUE;
}

void CXISLBeginEndTag::InsertActItem(CXISLActItem *pTag)
{
	m_pXISLAct->InsertActItem(pTag);
}

//SWitch^O̍폜
//2003/5/16@
BOOL CXISLBeginEndTag::DeleteSwitch(CXISLSwitchTag *pSTag)
{
	return m_pXISLAct->DeleteSwitch(pSTag);
}
//폜
//2003/5/15@
BOOL CXISLBeginEndTag::DeleteActItem(CXISLActItem *pTag)
{
	return m_pXISLAct->DeleteActItem(pTag);
}

BOOL CXISLBeginEndTag::DeleteIf(CXISLIfTag *pIfTag)
{
	return m_pXISLAct->DeleteIf(pIfTag);
}

//폜
//2003/5/20@
void CXISLBeginEndTag::DeleteAllAct()
{
	CXISLTag *pTag;
	while(m_pXISLAct->m_ActionList.IsEmpty() == FALSE){
		pTag = (CXISLTag*)(m_pXISLAct->m_ActionList.GetHead());
		if(pTag->m_nTagType == ID_TAG_OUTPUT || pTag->m_nTagType == ID_TAG_RETURN || pTag->m_nTagType == ID_TAG_ASSIGN
			|| pTag->m_nTagType == ID_TAG_CALL || pTag->m_nTagType == ID_TAG_GOTO){
			m_pXISLAct->DeleteActItem((CXISLActItem *)pTag);
		}
		//Ǐo̓^O
		/*else if(pTag->m_nTagType == ID_TAG_SOUTPUT || pTag->m_nTagType == ID_TAG_POUTPUT || pTag->m_nTagType == ID_TAG_AOUTPUT){
			//
		}*/
		//Switch^O
		else if(pTag->m_nTagType == ID_TAG_SWITCH){
			CXISLSwitchTag *pSTag = (CXISLSwitchTag *)(m_pXISLAct->m_ActionList.GetHead());
			pSTag->DeleteItemIntoCase();
			m_pXISLAct->DeleteActItem(pSTag);
		}
		//EXIT^O
		else if(pTag->m_nTagType == ID_TAG_EXIT){
			m_pXISLAct->SetExit(FALSE);
		}
	}
}
/*
CXISLOutputBrowser* CXISLBeginEndTag::CreateOutputBrowser(int nType,int nEvent,LPCTSTR lpszWName,LPCTSTR lpszParam,int nParam)
{
	CXISLOutputBrowser *pOutputTag;
	switch(nEvent)
	{
	case ID_BROWSEREVENT_CLOSE:
	case ID_BROWSEREVENT_MAX:
	case ID_BROWSEREVENT_MIN:
		pOutputTag = new CXISLOutputBrowser((CXISLTag*)m_pParentTag,nType,nEvent,lpszWName);
		break;
	case ID_BROWSEREVENT_MOVE:
		pOutputTag = new CXISLOutputBrowser((CXISLTag*)m_pParentTag,nType,nEvent,lpszWName,nParam);
		break;
	case ID_BROWSEREVENT_OPEN:
		pOutputTag = new CXISLOutputBrowser((CXISLTag*)m_pParentTag,nType,nEvent,lpszWName,nParam,lpszParam);
		break;
	case ID_BROWSEREVENT_NAVI:
		pOutputTag = new CXISLOutputBrowser((CXISLTag*)m_pParentTag,nType,nEvent,lpszWName,lpszParam);
		break;
	default:
		return NULL;
	}

	return pOutputTag;
}
*/

//CSize CXISLActTag::DrawXISLFlow(CDC *pDC,int nX,int nY)
//@\@Faction̗}
//@FCDC *pDC:foCXReLXg
//		  int nX, nY:`Jnʒu
//ԂlFCSize:`͈
CSize CXISLBeginEndTag::DrawXISLFlow(CDC *pDC,int nX,int nY)
{
	int nViewSizeX,nViewSizeY;
	CDC MemDC;
	MemDC.CreateCompatibleDC(pDC);
		
	CBitmap FlowBMP;
	BITMAP bmp;

	FlowBMP.LoadBitmap(m_nBmpID);

	FlowBMP.GetBitmap(&bmp);
	CBitmap *pOldBMP = MemDC.SelectObject(&FlowBMP);

	pDC->BitBlt(nX,nY,bmp.bmWidth,bmp.bmHeight,&MemDC,0,0,SRCCOPY);
	FlowBMP.DeleteObject();
	SetRectBMP(nX,nY,bmp.bmWidth,bmp.bmHeight);

	nX += bmp.bmWidth/2;
	nY += bmp.bmHeight-1;

	pDC->MoveTo(nX,nY);
	POINT point[3];
	point[0].x = nX;
	nY += 20;
	point[0].y = nY;
	nX += bmp.bmWidth;
	point[1].x = nX+5;
	point[1].y = nY;
	point[2].x = nX;
	nY += 35;
	point[2].y = nY;

	int nBX = nX;
	CPen *pOldPen,linePen;
	linePen.CreatePen(PS_SOLID,3,RGB(0,0,0));
	pOldPen = pDC->SelectObject(&linePen);

	pDC->PolyBezierTo(point,3);

	int nMaxX = nX;
	if(m_pXISLAct)
	{
		CSize sizeAct = m_pXISLAct->DrawXISLFlow(pDC,nX,nY);
		if(nMaxX < sizeAct.cx)
			nMaxX = sizeAct.cx;
		nY = sizeAct.cy;
	}

	if(m_pXISLAct->m_ActionList.GetCount() == 0)
	{
		pDC->MoveTo(nBX+4,nY-6);
		pDC->LineTo(nBX,nY);
		pDC->MoveTo(nBX-4,nY-6);
		pDC->LineTo(nBX,nY);
	}
	nViewSizeX = nMaxX;
	nViewSizeY = nY;
	MemDC.SelectObject(pOldBMP);
	FlowBMP.DeleteObject();
	MemDC.DeleteDC();

	return CSize(nX,nY);
}

//CXISLTag* CXISLDialogTag::FindTag(POINT point,BOOL bOnly)
//@\@FNbNꂽ^OT
//@Fpoint:W
//		  bOnly:TRUE͎̎ĝݔf
//ԂlFY^OBNULL
CXISLTag* CXISLBeginEndTag::FindTag(POINT point,BOOL bOnly)
{
	m_rectBMP.NormalizeRect();
	if(m_rectBMP.PtInRect(point))
		return (CXISLTag*)this;
	else if(!bOnly)
	{
		CXISLTag* pTag;
		if(m_pXISLAct)
		{
			pTag = m_pXISLAct->FindTag(point,TRUE);
			if(pTag)
				return pTag;
		}
	}

	return NULL;
}